package com.jonohennessy {
	import flash.display.*;
	import flash.events.*;
	import com.adamsearle.utils.BackgroundMusicPlayer;
	
	public class MenuView extends MovieClip {
		
		// Declare vars - note automatically declare stage instances is disabled
		public var middle_mc:MovieClip;
		private var hennessyModel:HennessyModel;
		private var hennessyController:HennessyController;
		private var musicPlayer:BackgroundMusicPlayer;

		public function MenuView() {
			//trace("hello menu, my clip x is: " + x);
			hennessyController = HennessyController(root);
			hennessyModel = hennessyController.getModel();
			musicPlayer = hennessyController.getMusicPlayer();
		}
		
		private function menuClickListener(e:MouseEvent):void {
			trace("menu clicked, target: " + e.target.name);
			
			// If allowed to respond
			if (!hennessyModel.getAnimatingLock()) {
			
				// Switch to determine button clicked
				// Two options: columnOut or fadeOut
				switch (e.target.name) {
					case "optical_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_OPTICAL);
						gotoAndPlay("columnOut");
						break;
					case "sunwear_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_SUNWEAR);
						gotoAndPlay("columnOut");
						break;
					case "promo_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_PROMO);
						gotoAndPlay("columnOut");
						break;
					case "thestory_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_THESTORY);
						gotoAndPlay("columnOut");
						break;
					case "news_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_NEWS);
						gotoAndPlay("columnOut");
						break;
					case "agents_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_AGENTS);
						gotoAndPlay("columnOut");
						break;
					case "contact_btn":
						hennessyModel.setMode(HennessyModel.CONTENT_CONTACT);
						gotoAndPlay("columnOut");
						break;
					default:
						trace("!! ----- Unknown menuClickListener target: " + e.target.name);
				}
				
				// Lock due to animation
				hennessyModel.setAnimatingLock(true);
				
				// Tell the menu
				hennessyController.menuClicked();
			}
		}
		
		// Music toggle button
		private function musicToggleListener(e:MouseEvent):void {
			musicPlayer.toggleHandler();
		}
		
		public function playReturn():void {
			gotoAndPlay("returning");
		}
		
		private function returnComplete():void {
			hennessyController.menuReturnComplete();
		}
	}
}